﻿<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Towary" %>
<%@ Import Namespace="Soneta.CRM" %>
<%@ Import Namespace="Soneta.Handel" %>
<%@ Import Namespace="Soneta.Handel.Forms" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Types" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >

<script runat="server">

    class NumerComparer : IComparer
    {
        public int Compare(object obj1, object obj2)
        {
            DokumentHandlowy d1 = obj1 as DokumentHandlowy;
            DokumentHandlowy d2 = obj2 as DokumentHandlowy;
            if (d1 == null && d2 == null) return 0;
            if (d1 == null) return 1;
            if (d2 == null) return -1;

            if (d1.Numer.Symbol == d2.Numer.Symbol) return d1.Numer.Numer.CompareTo(d2.Numer.Numer);
            return d1.Numer.Symbol.CompareTo(d2.Numer.Symbol);
        }
    }

    IEnumerable PrzygotujView() {
        
        if (dc.Context.Contains(typeof(DokumentHandlowy[])))
        {
            DokumentHandlowy[] doks = (DokumentHandlowy[])dc[typeof(DokumentHandlowy[])];
            ArrayList l = new ArrayList(doks);
            l.Sort(new NumerComparer());
            return l;
        }
        else
            throw new Exception("Brak listy dokumentów handlowych w kontekście");
        
    }


    public class Total : IComparable {
        readonly string numerPelny;
        public Total(string numerPelny) {
            this.numerPelny = numerPelny;
        }
        public string NumerPelny {
            get { return numerPelny; }
        }
        public int CompareTo(object obj) {
            Total t = (Total)obj;
            return NumerPelny.CompareTo(t.NumerPelny);
        }
    }
    
    
    
    protected void dc_ContextLoad(object sender, EventArgs e) {
        IEnumerable l = PrzygotujView();
        ArrayList arr = new ArrayList();

        string seria = "";
        int last = 0;
        foreach (DokumentHandlowy dok in l)
        {
            if (seria != dok.Numer.Symbol)
            {
                //nowa numeracja
                seria = dok.Numer.Symbol;
                last = dok.Numer.Numer;
            }
            else
            {
                last++;
                if (dok.Numer.Numer > last)
                {
                    int numlen = 0;
                    string numlens = "";
                    int start = dok.Definicja.Numeracja.Wzor.IndexOf("*:");
                    if (start!=-1)
                    {
                        int stop = dok.Definicja.Numeracja.Wzor.IndexOf("/", start);
                        if (stop!=-1)
                            numlens = dok.Definicja.Numeracja.Wzor.Substring(start+2, stop-start-2);
                        else
                            numlens = dok.Definicja.Numeracja.Wzor.Substring(start+2);
                    }
                    if (int.TryParse(numlens, out numlen)) ;
                    
                        
                    for (int i = last; i < dok.Numer.Numer; i++)
                    {
                        
                        arr.Add(new Total( dok.Numer.Symbol.Replace("*", i.ToString().PadLeft(numlen, '0') )));
                    }
                    last = dok.Numer.Numer;
                }
            }
            
        }
        
        arr.Sort();
        Grid.DataSource = arr;
    }
    
</script>

<html>
	<head>
		<title>Brakujące numery dokumentów</title>
		<meta content="C#" name="CODE_LANGUAGE" />
		<meta content="JavaScript" name="vs_defaultClientScript" />
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
	</head>
	<body>
		<form method="post" runat="server">
			<ea:DataContext id="dc" runat="server" oncontextload="dc_ContextLoad"></ea:DataContext>
			<eb:ReportHeader id="ReportHeader" runat="server" title="Brakujące numery dokumentów"></eb:ReportHeader>
			<ea:Grid id="Grid" runat="server" RowTypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel">
				<Columns>
					<ea:GridColumn runat="server" Width="4" Align="Right" DataMember="#" Caption="Lp."></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" DataMember="NumerPelny" Caption="Numer"></ea:GridColumn>
				</Columns>
			</ea:Grid>
			<eb:ReportFooter id="ReportFooter" runat="server"></eb:ReportFooter>
		</form>
	</body>
</html>

